/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class BlockStats
implements Runnable {
    private Player player;
    private Block block;
    private Connection conn;
    private String table;

    BlockStats(Connection conn, Player player, Block block, String table) {
        this.player = player;
        this.conn = conn;
        this.block = block;
        this.table = table;
    }

    @Override
    public void run() {
        if (this.conn == null) {
            this.player.sendMessage(ChatColor.RED + "Failed to create database connection");
            return;
        }
        if (this.table == null) {
            this.player.sendMessage(ChatColor.RED + "This world isn't logged");
            return;
        }
        boolean hist = false;
        Statement ps = null;
        ResultSet rs = null;
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
        try {
            try {
                this.conn.setAutoCommit(false);
                ps = this.conn.prepareStatement("SELECT * FROM `" + this.table + "` LEFT JOIN `" + this.table + "-sign` USING (`id`) INNER JOIN `lb-players` USING (`playerid`) WHERE `x` = ? AND `y` = ? AND `z` = ? ORDER BY `date` DESC", 1);
                ps.setInt(1, this.block.getX());
                ps.setInt(2, this.block.getY());
                ps.setInt(3, this.block.getZ());
                rs = ps.executeQuery();
                this.player.sendMessage(ChatColor.DARK_AQUA + "Block history (" + this.block.getX() + ", " + this.block.getY() + ", " + this.block.getZ() + "): ");
                while (rs.next()) {
                    String msg = String.valueOf(formatter.format(rs.getTimestamp("date"))) + " " + rs.getString("playername") + " ";
                    msg = (rs.getInt("type") == 63 || rs.getInt("type") == 68) && rs.getString("signtext") != null ? String.valueOf(msg) + "created " + rs.getString("signtext") : (rs.getInt("type") == 54 && rs.getInt("replaced") == 54 ? String.valueOf(msg) + "looked inside" : (rs.getInt("type") == 0 ? String.valueOf(msg) + "destroyed " + this.getMaterialName(rs.getInt("replaced")) : (rs.getInt("replaced") == 0 ? String.valueOf(msg) + "created " + this.getMaterialName(rs.getInt("type")) : String.valueOf(msg) + "replaced " + this.getMaterialName(rs.getInt("replaced")) + " with " + this.getMaterialName(rs.getInt("type")))));
                    this.player.sendMessage(ChatColor.GOLD + msg);
                    hist = true;
                }
                if (!hist) {
                    this.player.sendMessage(ChatColor.DARK_AQUA + "None.");
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, "[LogBlock BlockStats] SQL exception", ex);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException ex2) {
                    LogBlock.log.log(Level.SEVERE, "[LogBlock BlockStats] SQL exception on close", ex2);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, "[LogBlock BlockStats] SQL exception on close", ex);
            }
        }
    }

    private String getMaterialName(int type) {
        return Material.getMaterial((int)type).toString().toLowerCase().replace('_', ' ');
    }
}

